/*
 *******************************************************
 application:		WAP Finger
 author:		Ollie (ollie@atstake.com)
 version:		0.3.sig[2]
 known bugs &
 design issues:		
 

 to-do:			Improve finger printing for WAPLite
 			Improve general method of storing finger prints
 
 code changlog:		
 			28-Nov-2001 - New length function patch supplied by srk@atstake.com
 			27-Nov-2001 - New oprint function patch supplied by srk@atstake.com
 			26-Nov-2001 - Fixed the munged post request issues (see 23rd changlog)
 			23-Nov-2001 - Fixed packet length issues which resulted in
 				      random data from the stack being put in as the
 				      length.
 			??-Jul-2001 - Developed for the first time

 sig changlog:		 			
 			28-Nov-2001 - New OpenWave sig added
 			??-Sep-2001 - 2 new sigs added (Jinny and theMOBILIZER)
 			??-Jul-2001 - Initial release
 			
 WAP spec doc:		WAP-203-WSP-20000504-a.pdf
 
 gateways tested
 with:			Ericsson Enterprise Gateway 2.0
 			WAPLite 1.1 (SP1) & 2.0
 			WAPServ 1.0
 			Nokia's ActiveServ 
 			Kannel 1.0.3-1
 			Jataayu
 			Jataayu Enterprise WAP Server
			Jinny 1.1
			theMOBILIZER Secure WAP Gateway 2.4 (BL14.17)
			OpenWave
 *******************************************************
*/
#ifdef _WIN32
#include <Winsock2.h>
#include <Windows.h>
#define snprintf _snprintf
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <stdio.h>

/* functions */
void usage();
void oprint(char bufdump[40000],int buflen);
void finger(char bufdump[40000],int buflen);

/* varibles */
unsigned char sc[11][10000]={
			   "\x01",	/* WSP connect */

			   /* Client compatibility options */
			   "\x80\x88", 	/* WSP options: Accept: text/vnd.wap.wml */
			   "\x80\x94", 	/* WSP options: Accept: application/vnd.wap.wmlc */
			   "\x80\xA1", 	/* WSP options: Accept: image/vnd.wap.wbmp */
			   "\x80\x9D", 	/* WSP options: Accept: image/gif */
			   "\x80\x9E", 	/* WSP options: Accept: image/jpeg */
			   "\x80\x89", 	/* WSP options: Accept: text/vnd.wap.wmlscript */
			   "\x80\x95", 	/* WSP options: Accept: application/vnd.wap.wmlscriptc */
		   
			   /* User Agent */
			   "\xA9",	/* WSP options: UserAgent */
			   "stake",
			   
			   "http://whoru?/",
			};
			
unsigned char ids[11][10000]={
			   /* Ericsson Enterprise WAP Gateway 2.0 */
			   "\x01\x04\x40\x01\x00\x00", 	
	
			   /* Nokia Activ Serv 2.0 Professional */
			   "\x01\x04\x60\x21\x03\x94\x81\xea\x45\x6e\x63\x6f\x64\x69\x6e\x67\x2d\x76\x65\x72\x73\x69\x6f\x6e\x00\x31\x2e\x32\x00\x84\x80\x92\x04\x3b\x71\x04\x7b\x01\x04\x6a\x00\x7f\xe7\x36\x03\x45\x72\x72\x6f\x72\x00\x01\x60\xe8\x46\x21\x03\x62\x61\x63\x6b\x00\x01\x32\x01\x03\x48\x6f\x73\x74\x20\x6e\x6f\x74\x20\x6b\x6e\x6f\x77\x6e\x20\x62\x79\x20\x74\x68\x65\x20\x67\x61\x74\x65\x77\x61\x79\x00\x01\x01\x01\x00",
			   
			   /* WAPServ Lite 1.0 */
			   "\x01\x04\x20\x01\x00\x3c\x3f\x78\x6d\x6c\x20\x76\x65\x72\x73\x69\x6f\x6e\x3d\x22\x31\x2e\x30\x22\x3f\x3e\x0d\x0a\x3c\x21\x44\x4f\x43\x54\x59\x50\x45\x20\x77\x6d\x6c\x20\x50\x55\x42\x4c\x49\x43\x20\x22\x2d\x2f\x2f\x57\x41\x50\x46\x4f\x52\x55\x4d\x2f\x2f\x44\x54\x44\x20\x57\x4d\x4c\x20\x31\x2e\x31\x2f\x2f\x45\x4e\x22\x20\x22\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x77\x61\x70\x66\x6f\x72\x75\x6d\x2e\x6f\x72\x67\x2f\x44\x54\x44\x2f\x77\x6d\x6c\x5f\x31\x2e\x31\x2e\x78\x6d\x6c\x22\x3e\x0d\x0a\x3c\x77\x6d\x6c\x3e\x0d\x0a\x20\x20\x3c\x63\x61\x72\x64\x3e\x0d\x0a\x20\x20\x20\x20\x3c\x70\x3e\x54\x68\x65\x72\x65\x20\x77\x61\x73\x20\x61\x6e\x20\x65\x72\x72\x6f\x72\x20\x72\x65\x74\x72\x69\x65\x76\x69\x6e\x67\x20\x74\x68\x65\x20\x72\x65\x71\x75\x65\x73\x74\x65\x64\x20\x66\x69\x6c\x65\x2e\x3c\x2f\x70\x3e\x0d\x0a\x20\x20\x3c\x2f\x63\x61\x72\x64\x3e\x0d\x0a\x3c\x2f\x77\x6d\x6c\x3e\x0d\x0a\x00",
			   
			   /* Infinite WAPLite 2.0 */
			   "\x01\x04\x20\x15\x94\x88\x02\x82\x80\x88\x80\x88\x89\x92\x04\x3b\x99\xe4\x8e\x94\x04\x12\xf7\x92\x90\x01\x04\x6a\x00\x7f\xe7\x36\x03\x45\x72\x72\x6f\x72\x00\x01\x60\xe8\x46\x18\x03\x42\x61\x63\x6b\x00\x01\x32\x01\x03\x45\x72\x72\x6f\x72\x3a\x20\x43\x61\x6e\x6e\x6f\x74\x20\x6c\x6f\x63\x61\x74\x65\x20\x73\x65\x72\x76\x65\x72\x20\x77\x68\x6f\x72\x75\x3f\x2e\x20\x00\x01\x01\x01\x00",
			   
			   /* Infinite WAPLite v1.0 SP1 */
			   "\x01\x04\x20\x15\x94\x88\x02\x82\x80\x88\x80\x88\x89\x92\x04\x3b\x99\xe5\x02\x94\x04\x12\xf7\x84\x80\x01\x04\x6a\x00\x7f\xe7\x36\x03\x45\x72\x72\x6f\x72\x00\x01\x60\xe8\x46\x01\x32\x01\x03\x45\x72\x72\x6f\x72\x3a\x20\x43\x61\x6e\x6e\x6f\x74\x20\x6c\x6f\x63\x61\x74\x65\x20\x73\x65\x72\x76\x65\x72\x20\x77\x68\x6f\x72\x75\x3f\x2e\x20\x00\x01\x01\x01\x00",
			   
			   /* Kannel 1.0.3-1 */
			   "\x01\x04\x62\x03\x83\x8d\x80\x00",
			   
			   /* Jataayu */
			   "\x01\x04\x62\x01\x94\x01\x04\x6a\x00\x7f\x67\x60\xe8\x46\x18\x03\x62\x61\x63\x6b\x00\x01\x32\x01\x03\x62\x61\x64\x5f\x68\x6f\x73\x74\x6e\x61\x6d\x65\x00\x01\x01\x01\x00",
			   
			   /* Jataayu Enterprise WAP Server*/
			   "\x01\x04\x20\x01\x94\x01\x04\x6a\x00\x7f\x67\x60\xe8\x46\x18\x03\x62\x61\x63\x6b\x00\x01\x32\x01\x03\x65\x72\x72\x6f\x72\x20\x63\x6f\x6e\x6e\x65\x63\x74\x69\x6e\x67\x20\x74\x6f\x20\x6f\x72\x69\x67\x69\x6e\x20\x73\x65\x72\x76\x65\x72\x00\x01\x01\x01\x00",
			   
			   /* Jinny 1.1 */
			   "\x01\x04\x20\x15\x94\xa6\x4a\x69\x6e\x6e\x79\x57\x61\x70\x53\x65\x72\x76\x65\x72\x2f\x31\x2e\x31\x00\x01\x04\x04\x00\x7f\xe7\x55\x03\x6d\x65\x73\x73\x61\x67\x65\x00\x01\xe8\x38\x01\x32\x01\x60\x03\x20\x4e\x65\x74\x77\x6f\x72\x6b\x20\x65\x72\x72\x6f\x72\x20\x77\x68\x69\x6c\x65\x20\x66\x65\x74\x63\x68\x69\x6e\x67\x20\x64\x6f\x63\x75\x6d\x65\x6e\x74\x20\x00\x01\x01\x01\x00",
			   
			   /* theMOBILIZER Secure WAP Gateway 2.4 (BL14.17) */
			   "\x01\x04\x44\x04\x03\x94\x81\xea\x01\x04\x6a\x00\x7f\x67\xe8\x46\x01\x32\x01\x60\x03\x48\x54\x54\x50\x20\x53\x74\x61\x74\x75\x73\x20\x63\x6f\x64\x65\x3d\x34\x30\x34\x20\x4e\x6f\x74\x20\x46\x6f\x75\x6e\x64\x00\x01\x01\x01\x00",
			   
			   /* OpenWave v?.?? */
			   "\x01\x04\x60\x05\x94\x88\x02\x82\x80\x01\x04\x03\x00\x7f\x67\xf3\x3d\x01\x32\x01\x60\xe8\x38\x01\x32\x01\x03\x35\x30\x30\x3a\x20\x45\x72\x72\x6f\x72\x20\x4f\x63\x63\x75\x72\x72\x65\x64\x2e\x20\x50\x6c\x65\x61\x73\x65\x20\x63\x61\x6c\x6c\x20\x63\x75\x73\x74\x6f\x6d\x65\x72\x20\x63\x61\x72\x65\x00\x01\x01\x01\x00",
			};
			
unsigned char idsname[11][10000]={
			   "Ericsson Enterprise WAP Gateway 2.0",
	
			   "Nokia Activ Serv 2.0 Professional",
			   
			   "WAPServ Lite 1.0",
			   
			   "Infinite WAPLite 2.0 or 1.0 SP1",
			   
			   "Infinite WAPLite 1.0 SP1",
			   
			   "Kannel 1.0.3-1",
			   
			   "Jataayu",
			   
			   "Jataayu Enterprise WAP Server (RedHat/Windows)",
			      
			   "Jinny 1.1",
			   
			   "theMOBILIZER Secure WAP Gateway 2.4 (BL14.17)",
			   
			   "OpenWave ?.?",
			};
			
unsigned char tips[11][10000]={
			   "\npentesting tips:\n-o- none\n\n",
	
			   "\npentesting tips:\n-o- try requesting a URL such as http://yourdomain/\nsnmp scan the gateway with the public community string\n\n",
			   
			   "\npentesting tips:\n-o- there is a denial of service in this version\n\n",
			   
			   "\npentesting tips:\n-o- there is a bufferoverflow in v1.0 (SP1) and below\n\n",
			   
			   "\npentesting tips:\n-o- there is a bufferoverflow in v1.0 (SP1) and below\n\n",
			   
			   "\npentesting tips:\n-o- none\n\n",
			   
			   "\npentesting tips:\n-o- try requesting a URL such as localhost/../error.log\n\n",
			   
			   "\npentesting tips:\n-o- try requesting a URL such as localhost/../error.log over wsp\n-o- connect to port 80 and request /remote_jataayu/ with the username of admin and password of admin123\n-o- connect to port 80 and request /cgi-bin/INCLUDE\n-o- connect to port 80 and request /cgi-bin/.userinfo\n\n",
			   
			   "\npentesting tips:\n-o- none\n\n",
			   
			   "\npentesting tips:\n-o- try requesting a URL such as http://_/\n try requesting http://<server ip>:8080/infrastructure/smsapp - reveals path\n\n",
			   
			   "\npentesting tips:\n-o- none\n\n",
			   };
/* end varibles */

/*
 *******************************************************
 Function: Main
 *******************************************************
*/
main (int argc, char *argv[])
{
	char rcvbuf[40000],temp[1],request_message[40000],reqtype[4], reallen[8];
	int reqlen,X,sock,sp=0,rcvbufsize;
	unsigned short serverport=htons(9200);
	struct hostent *nametocheck;
	struct sockaddr_in serv_addr;
	struct in_addr attack;
	
#ifdef _WIN32
	WORD werd;
	WSADATA wsd;
	werd= MAKEWORD(2,0);
	WSAStartup(werd,&wsd);
#endif
	
	
	/* app banner */
	printf("oo0 @stake wap pentesting tookit 0oo\n");
	printf("wapfinger - v0.3.sig[2]\n");
	printf("author: ollie (ollie@atstake.com)\n");
	
	/* user supplied parameters */
	if(argc < 3) usage(); 
	
	nametocheck = gethostbyname (argv[1]);
	memcpy(&attack.s_addr,nametocheck->h_addr_list[0],4);
	
	serverport=ntohs((unsigned short)atoi(argv[2]));
	
	strcpy(reqtype,"\x40");
	
	/* info message */
	printf("requesting URI: %s\ngateway: %s on port: %d via request type: %x\n",sc[10],inet_ntoa(attack),htons(serverport),reqtype[0]);

	/* memset(request_message,0x00,1515); */
	
	/* the length of the requested URI */
	reqlen = strlen(sc[10]);
	sprintf(reallen,"%d",reqlen);
    
	/* packet contents */
	strcpy(request_message,sc[0]);
	strcat(request_message,reqtype);
	/*srk*/
	
	
	#if 0
        	strcat(request_message,reallen);
	#endif
	{
        	int curlen = strlen(request_message);
        	request_message[curlen++] = reqlen & 0xff;
        	request_message[curlen++] = '\0';
	}	
	/*!srk*/

	strcat(request_message,sc[10]);
	strcat(request_message,sc[1]);
	strcat(request_message,sc[2]);
	strcat(request_message,sc[3]);
	strcat(request_message,sc[4]);
	strcat(request_message,sc[5]);
	strcat(request_message,sc[6]);
	strcat(request_message,sc[7]);
	/* 
	
	This was taken out due to Nokia GW barfing because I didn't null
	terminate the packet..
	
	strcat(request_message,sc[8]);
	strcat(request_message,sc[9]);
	
	*/
		
	/* end of packet contents */

	/* ip stuff */
	sock = socket (AF_INET, SOCK_DGRAM, 0);
	memset (&serv_addr, 0, sizeof (serv_addr));
	serv_addr.sin_family=AF_INET;
	serv_addr.sin_addr.s_addr = attack.s_addr;
	serv_addr.sin_port = serverport;
	X=connect (sock, (struct sockaddr *) &serv_addr, sizeof (serv_addr));
	if(X==0)
	{
		
		printf("sent data to %s \n",inet_ntoa(attack));		
		send(sock,request_message,strlen(request_message)*sizeof(char),0);
		
		rcvbufsize = recv(sock, rcvbuf, 40000, 0);
		
		printf("recieved response\n");
		finger(rcvbuf,rcvbufsize);
		
		printf("recieved length: %d\n",rcvbufsize);

	}
	else
	{
		printf("couldn't connect\n",inet_ntoa(attack));
	}
	

	
#ifdef _WIN32
	closesocket(sock); 
#else
	close(sock);
#endif
	return 0;
}


/*
 *******************************************************
 Function: Usage
 Role	 : Prints out help screen
 *******************************************************
*/
void usage()
{
	printf("\n");
	printf("WAP gateway 	  - required\n");
	printf("WAP server port   - required\n\n");
	printf("syntax:	  wapfinger <wap gateway> <server port>\n");
	printf("example:  wapfinger 10.1.1.1 9200\n");
	exit(1);
}

/*
 *******************************************************
 Function: oprint
 Role	 : hex dumps said buffer
 Takes	 : buffer and length
 Notes	 : names inspired by hobbits oprint from netcat
 *******************************************************
*/
void oprint(bufdump,buflen)
	int buflen;
	char bufdump[2000];
{
	int c=0,c2=0;
		
	while (c <= buflen)
	{
		if (c2==16)
		{
			c2=c - 16;
			while (c2<c)
			{
				if (bufdump[c2] > 31 && bufdump[c2]<127)
					printf("%c",bufdump[c2]);
				else
					printf(".");
				c2++;
			}
			printf("\n");
			c2=0;
		}
		printf("%0.2x",bufdump[c] & 0xff);
		printf(" ");
		c++;
		c2++;
	}

	if(c2 != 1)
	{
		while(c2 < 16)
		{
			printf("   ");
			c2++;
			c++;
		}
		c2 = c - 16;
		while(c2 <= buflen)
		{
			if (bufdump[c2] > 31 && bufdump[c2]<127)
				printf("%c",bufdump[c2]);
			else
				printf(".");
			c2++;
		}
	}

	return;
}


/*
 *******************************************************
 Function: finger
 Role	 : id's remote WAP gateway
 Takes	 : buffer and length
 Notes	 : it's cheese, I should use files but at there are 
 	   only about 20 way servers in the world this should do
 	   for now
 *******************************************************
*/
void finger(bufdump,buflen)
	int buflen;
	char bufdump[40000];
{
	int c=0,c2=0;
	int result;	
		
	while (c < 11) { 		/* add a sig increase this */
	
		if (c == 1){
			result = memcmp(bufdump, ids[c], 35);} /* cater for bytes 36 and 37 changing on Nokias */
		else if (c == 3){
			result = memcmp(bufdump, ids[c], 15);} /* cater for bytes 16,17 and 18 changing on WAPLite 2 */
		else {
	  		result = memcmp(bufdump, ids[c], buflen);}
	  		
		if( result == 0 ){
      			printf("WAP gateway ID: %s\n",idsname[c]);
      			printf("%s",tips[c]);
      			c2=1; c=10;} 	/* add a sig increase this */
	c++;
	}

	if (c2<=0){
		printf("WAP gateway ID: unknown - please submit to ollie@atstake.com\n");
		printf("dump of gateway response:\n.start.\n");
		oprint(bufdump,buflen);		
		printf("\n.end.\n");
	}
}